//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Decrypt Enveloped PKCS-7 message
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define PKCS7E_FILE  "pkcs7_enc.bin"
#define DECRYPT_FILE "dec_res.bin"
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
//------------------------------------------------------------------------------
//     
// :
// 1.  
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY hKey;
 DWORD len,len2=0,sz;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //  PKCS7
 if (getFileLen(PKCS7E_FILE,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (PKCS7E_FILE,WBuf,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //     PKCS7
 if (!CPImportKey(hProv,WBuf,sz,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    
 len=sizeof(DWORD);
 if (!CPGetKeyParam(hProv,hKey,KP_PKCS7_DATA_SIZE,(BYTE*)&len2,&len,0)) {
   printf("CPGetKeyParam KP_PKCS7_DATA_SIZE Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 if (len2) {
   //  
   len=sizeof(WBuf);
   if (!CPGetKeyParam(hProv,hKey,KP_PKCS7_DATA,WBuf,&len,0)) {
     printf("CPGetKeyParam KP_PKCS7_DATA Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   //  
   if (!CPDecrypt(hProv,hKey,0,TRUE,0,WBuf,&len)) {
     printf("CPDecrypt Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   writeFile(DECRYPT_FILE,WBuf,len);
   WBuf[len]=0;
   printf("Data: [%s]\r\n",(char*)WBuf);
 }
 CPDestroyKey(hProv,hKey);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
